/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.item;

import java.util.List;
import net.creeperhost.chickens.handler.IColorSource;
import net.creeperhost.chickens.handler.LiquidEggFluidWrapper;
import net.creeperhost.chickens.init.ModItems;
import net.creeperhost.chickens.registry.LiquidEggRegistry;
import net.creeperhost.chickens.registry.LiquidEggRegistryItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemLiquidEgg
extends Item
implements IColorSource {
    public ItemLiquidEgg(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        if (!stack.m_41782_()) {
            return 0;
        }
        String[] strings = stack.m_41783_().m_128423_("id").toString().replace("\"", "").split(":");
        ResourceLocation resourceLocation = new ResourceLocation(strings[0], strings[1]);
        Fluid fluid = (Fluid)Registry.f_122822_.m_7745_(resourceLocation);
        if (fluid != null) {
            return fluid.getAttributes().getColor();
        }
        return 0;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        components.add((Component)new TranslatableComponent("item.liquid_egg.tooltip"));
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> subItems) {
        if (this.m_41389_(tab)) {
            for (LiquidEggRegistryItem liquid : LiquidEggRegistry.getAll()) {
                subItems.add((Object)ItemLiquidEgg.of(liquid));
            }
        }
    }

    public static ItemStack of(LiquidEggRegistryItem liquidEggRegistryItem) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.LIQUID_EGG.get());
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("id", liquidEggRegistryItem.getFluid().getRegistryName().toString());
        stack.m_41751_(compoundTag);
        return stack;
    }

    public static ItemStack of(FluidStack fluidStack) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.LIQUID_EGG.get());
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("id", fluidStack.getFluid().getRegistryName().toString());
        stack.m_41751_(compoundTag);
        return stack;
    }

    public Component m_7626_(ItemStack stack) {
        if (!stack.m_41782_()) {
            return super.m_7626_(stack);
        }
        String[] strings = stack.m_41783_().m_128461_("id").split(":");
        return new TranslatableComponent("item.liquid_egg." + strings[1] + ".name");
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext useOnContext) {
        BlockPos clickedPos = useOnContext.m_8083_().m_142300_(useOnContext.m_43719_());
        ItemStack stack = useOnContext.m_43722_();
        Level level = useOnContext.m_43725_();
        Fluid fluid = this.getFluid(stack);
        if (level.m_8055_(clickedPos).m_60795_() || level.m_8055_(clickedPos).m_60722_(fluid)) {
            level.m_7731_(clickedPos, fluid.m_76145_().m_76188_(), 3);
            useOnContext.m_43722_().m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public Fluid getFluid(ItemStack stack) {
        String id = stack.m_41783_().m_128461_("id");
        return (Fluid)Registry.f_122822_.m_7745_(new ResourceLocation(id));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new LiquidEggFluidWrapper(stack);
    }
}

